/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.sound;

import com.ornate.io.Buffer;
import com.ornate.sound.Synthesizer;

public final class Track {
    private static final Track[] tracks = new Track[5000];
    public static final int[] delays = new int[5000];
    private static byte[] output;
    private static Buffer riff;
    private final Synthesizer[] samples = new Synthesizer[10];
    private int remaining;
    private int length;

    private Track() {
    }

    public static void unpack(Buffer incoming) {
        output = new byte[441000];
        riff = new Buffer(output);
        Synthesizer.init();
        int id;
        while ((id = incoming.readUShort()) != 65535) {
            Track.tracks[id] = new Track();
            tracks[id].decode(incoming);
            Track.delays[id] = tracks[id].calculateDelay();
        }
        return;
    }

    public static Buffer data(int loops, int id) {
        if (tracks[id] != null) {
            Track soundTrack = tracks[id];
            return soundTrack.pack(loops);
        }
        return null;
    }

    private void decode(Buffer stream) {
        for (int synthesizer = 0; synthesizer < 10; ++synthesizer) {
            int valid = stream.readUByte();
            if (valid == 0) continue;
            --stream.pos;
            this.samples[synthesizer] = new Synthesizer();
            this.samples[synthesizer].load(stream);
        }
        this.remaining = stream.readUShort();
        this.length = stream.readUShort();
    }

    private int calculateDelay() {
        int offset = 9999999;
        for (int syntheziser = 0; syntheziser < 10; ++syntheziser) {
            if (this.samples[syntheziser] == null || this.samples[syntheziser].offset / 20 >= offset) continue;
            offset = this.samples[syntheziser].offset / 20;
        }
        if (this.remaining < this.length && this.remaining / 20 < offset) {
            offset = this.remaining / 20;
        }
        if (offset == 9999999 || offset == 0) {
            return 0;
        }
        for (int synthesizer = 0; synthesizer < 10; ++synthesizer) {
            if (this.samples[synthesizer] == null) continue;
            this.samples[synthesizer].offset -= offset * 20;
        }
        if (this.remaining < this.length) {
            this.remaining -= offset * 20;
            this.length -= offset * 20;
        }
        return offset;
    }

    private Buffer pack(int loops) {
        int size = this.mix(loops);
        Track.riff.pos = 0;
        riff.writeInt(1380533830);
        riff.writeLEInt(36 + size);
        riff.writeInt(1463899717);
        riff.writeInt(1718449184);
        riff.writeLEInt(16);
        riff.writeLEShort(1);
        riff.writeLEShort(1);
        riff.writeLEInt(22050);
        riff.writeLEInt(22050);
        riff.writeLEShort(1);
        riff.writeLEShort(8);
        riff.writeInt(1684108385);
        riff.writeLEInt(size);
        Track.riff.pos += size;
        return riff;
    }

    private int mix(int loops) {
        int duration = 0;
        for (int synthesizer = 0; synthesizer < 10; ++synthesizer) {
            if (this.samples[synthesizer] == null || this.samples[synthesizer].duration + this.samples[synthesizer].offset <= duration) continue;
            duration = this.samples[synthesizer].duration + this.samples[synthesizer].offset;
        }
        if (duration == 0) {
            return 0;
        }
        int sampleCount = 22050 * duration / 1000;
        int loopStart = 22050 * this.remaining / 1000;
        int loopEnd = 22050 * this.length / 1000;
        if (loopStart < 0 || loopStart > sampleCount || loopEnd < 0 || loopEnd > sampleCount || loopStart >= loopEnd) {
            loops = 0;
        }
        int size = sampleCount + (loopEnd - loopStart) * (loops - 1);
        for (int offset = 44; offset < size + 44; ++offset) {
            Track.output[offset] = -128;
        }
        for (int synthesizer = 0; synthesizer < 10; ++synthesizer) {
            if (this.samples[synthesizer] == null) continue;
            int synthDuration = this.samples[synthesizer].duration * 22050 / 1000;
            int synthOffset = this.samples[synthesizer].offset * 22050 / 1000;
            int[] samples = this.samples[synthesizer].synthesize(synthDuration, this.samples[synthesizer].duration);
            for (int sample = 0; sample < synthDuration; ++sample) {
                int n = sample + synthOffset + 44;
                output[n] = (byte)(output[n] + (byte)(samples[sample] >> 8));
            }
        }
        if (loops > 1) {
            loopStart += 44;
            int k2 = (size += 44) - (sampleCount += 44);
            if (sampleCount - (loopEnd += 44) >= 0) {
                System.arraycopy(output, loopEnd, output, loopEnd + k2, sampleCount - loopEnd);
            }
            for (int k3 = 1; k3 < loops; ++k3) {
                int l2 = (loopEnd - loopStart) * k3;
                System.arraycopy(output, loopStart, output, loopStart + l2, loopEnd - loopStart);
            }
            size -= 44;
        }
        return size;
    }
}

