/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.util;

import com.ornate.Client;
import com.ornate.cache.FileStore;
import com.ornate.cache.def.ItemDefinition;
import com.ornate.cache.factory.ItemSpriteFactory;
import com.ornate.cache.graphics.SimpleImage;
import com.ornate.sign.SignLink;
import com.ornate.util.FileUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;

public final class CacheUtils {
    static int imageAmount = 0;

    public static void repackCacheIndex(Client client, FileStore.Store cacheIndex) {
        System.out.println("Started repacking index " + cacheIndex.getIndex() + ".");
        int indexLength = new File(SignLink.indexLocation(cacheIndex.getIndex(), -1)).listFiles().length;
        File[] file = new File(SignLink.indexLocation(cacheIndex.getIndex(), -1)).listFiles();
        try {
            for (int index = 0; index < indexLength; ++index) {
                int fileIndex = Integer.parseInt(CacheUtils.getFileNameWithoutExtension(file[index].toString()));
                byte[] data = FileUtils.fileToByteArray(cacheIndex.getIndex(), fileIndex);
                if (data != null && data.length > 0) {
                    client.indices[cacheIndex.getIndex()].writeFile(data.length, data, fileIndex);
                    System.out.println("Repacked cache index " + cacheIndex.getIndex() + " file index " + fileIndex + ".");
                    continue;
                }
                System.err.println("Unable to locate cache index " + cacheIndex.getIndex() + " file index " + fileIndex + ".");
            }
        }
        catch (Exception ex) {
            System.err.println("Error packing cache index " + cacheIndex.getIndex() + ".");
        }
        System.out.println("Finished repacking " + cacheIndex.getIndex() + ".");
    }

    public static String getFileNameWithoutExtension(String fileName) {
        File tmpFile = new File(fileName);
        tmpFile.getName();
        int whereDot = tmpFile.getName().lastIndexOf(46);
        if (0 < whereDot && whereDot <= tmpFile.getName().length() - 2) {
            return tmpFile.getName().substring(0, whereDot);
        }
        return "";
    }

    public static Image makeColorTransparent(BufferedImage im, final Color color) {
        RGBImageFilter filter = new RGBImageFilter(){
            public int markerRGB;
            {
                this.markerRGB = color.getRGB() | 0xFF000000;
            }

            @Override
            public final int filterRGB(int x, int y, int rgb) {
                if ((rgb | 0xFF000000) == this.markerRGB) {
                    return 0xFFFFFF & rgb;
                }
                return rgb;
            }
        };
        FilteredImageSource ip = new FilteredImageSource(im.getSource(), filter);
        return Toolkit.getDefaultToolkit().createImage(ip);
    }

    private static BufferedImage imageToBufferedImage(Image image) {
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g2 = bufferedImage.createGraphics();
        g2.drawImage(image, 0, 0, null);
        g2.dispose();
        return bufferedImage;
    }

    public static void dumpImageOld(SimpleImage image, String name) {
        File directory = new File(SignLink.findCacheDir() + "/itemspritesdump/");
        if (!directory.exists()) {
            System.out.println("Creating directory");
            directory.mkdir();
        } else {
            System.out.println("Directory exists.");
        }
        BufferedImage bi = new BufferedImage(image.width, image.height, 1);
        bi.setRGB(0, 0, image.width, image.height, image.pixels, 0, image.width);
        Image img = CacheUtils.makeColorTransparent(bi, new Color(0, 0, 0));
        BufferedImage trans = CacheUtils.imageToBufferedImage(img);
        File f = new File(SignLink.findCacheDir() + "/itemspritesdump/" + name + ".png");
        boolean duplicate = false;
        if (f.exists() && !f.isDirectory()) {
            ++imageAmount;
            duplicate = true;
        }
        try {
            System.out.println("Dump: " + name);
            if (duplicate) {
                File out = new File(SignLink.findCacheDir() + "/itemspritesdump/" + name + ".png");
                ImageIO.write((RenderedImage)trans, "png", out);
            } else {
                File out = new File(SignLink.findCacheDir() + "/itemspritesdump/" + name + ".png");
                ImageIO.write((RenderedImage)trans, "png", out);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void dumpImage(SimpleImage image, String name) {
        File directory = new File(SignLink.findCacheDir() + "/itemspritesdump/");
        if (!directory.exists()) {
            directory.mkdir();
        }
        BufferedImage bi = new BufferedImage(image.width, image.height, 1);
        bi.setRGB(0, 0, image.width, image.height, image.pixels, 0, image.width);
        Image img = CacheUtils.makeColorTransparent(bi, new Color(0, 0, 0));
        BufferedImage trans = CacheUtils.imageToBufferedImage(img);
        try {
            File out = new File(SignLink.findCacheDir() + "/itemspritesdump/" + name + ".png");
            ImageIO.write((RenderedImage)trans, "png", out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void dumpItemImages(int idStart, int idEnd, int width, int height) {
        for (int id = idStart; id < idEnd; ++id) {
            SimpleImage image = ItemSpriteFactory.get_sized_item_sprite(id, 1, 0, width, height, true);
            if (image == null) continue;
            CacheUtils.dumpImage(image, Integer.toString(id));
        }
    }

    public static void dumpItemImages(int idStart, int idEnd) {
        for (int id = idStart; id < idEnd; ++id) {
            SimpleImage image = ItemSpriteFactory.get_item_sprite(id, 1, 0);
            if (image == null) continue;
            CacheUtils.dumpImage(image, Integer.toString(id));
        }
    }

    public static void dumpItemImagesOld(boolean dumpByName, int idStart, int idEnd) {
        for (int id = idStart; id < idEnd + 1; ++id) {
            ItemDefinition itemInstance = ItemDefinition.get(id);
            SimpleImage image = ItemSpriteFactory.get_item_sprite(id, 1, 0);
            boolean itemIsCoinType = false;
            if (image != null) {
                System.out.println("Image isn't null");
                String itemName = Integer.toString(id);
                if (ItemDefinition.get((int)id).name == null || ItemDefinition.get((int)id).name.equals("null")) continue;
                if (dumpByName) {
                    itemName = ItemDefinition.get((int)id).name;
                    if (itemInstance != null && itemInstance.stackable == 1) {
                        itemIsCoinType = true;
                    }
                }
                CacheUtils.dumpImage(image, itemName);
                if (!itemIsCoinType) continue;
                for (int index = 0; index < itemInstance.countobj.length; ++index) {
                    if (itemInstance.countobj[index] <= 0 || (image = ItemSpriteFactory.get_item_sprite(itemInstance.countobj[index], 1, 0)) == null) continue;
                    CacheUtils.dumpImage(image, itemName);
                }
                continue;
            }
            System.out.println("Image is null.");
        }
    }
}

