/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.util;

import com.ornate.io.Buffer;

public final class ChatMessageCodec {
    private static final char[] VALID_CHARACTERS = new char[]{' ', 'e', 't', 'a', 'o', 'i', 'h', 'n', 's', 'r', 'd', 'l', 'u', 'm', 'w', 'c', 'y', 'f', 'g', 'p', 'b', 'v', 'k', 'x', 'j', 'q', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ' ', '!', '?', '.', ',', ':', ';', '(', ')', '-', '&', '*', '\\', '\'', '@', '#', '+', '=', '\u00a3', '$', '%', '\"', '[', ']'};
    private static final char[] message = new char[100];
    private static final Buffer stream = new Buffer(new byte[100]);

    public static String decode(int length, Buffer buffer) {
        int index = 0;
        int next = -1;
        for (int count = 0; count < length; ++count) {
            int in = buffer.readUnsignedByte();
            int charIndex = in >> 4 & 0xF;
            if (next == -1) {
                if (charIndex < 13) {
                    ChatMessageCodec.message[index++] = VALID_CHARACTERS[charIndex];
                } else {
                    next = charIndex;
                }
            } else {
                ChatMessageCodec.message[index++] = VALID_CHARACTERS[(next << 4) + charIndex - 195];
                next = -1;
            }
            charIndex = in & 0xF;
            if (next == -1) {
                if (charIndex < 13) {
                    ChatMessageCodec.message[index++] = VALID_CHARACTERS[charIndex];
                    continue;
                }
                next = charIndex;
                continue;
            }
            ChatMessageCodec.message[index++] = VALID_CHARACTERS[(next << 4) + charIndex - 195];
            next = -1;
        }
        boolean capitaliseNext = true;
        for (int count = 0; count < index; ++count) {
            char character = message[count];
            if (capitaliseNext && character >= 'a' && character <= 'z') {
                int n = count;
                message[n] = (char)(message[n] + 65504);
                capitaliseNext = false;
            }
            if (character != '.' && character != '!' && character != '?') continue;
            capitaliseNext = true;
        }
        return new String(message, 0, index);
    }

    public static void encode(String string, Buffer buffer) {
        if (string.length() > 80) {
            string = string.substring(0, 80);
        }
        string = string.toLowerCase();
        int next = -1;
        for (int index = 0; index < string.length(); ++index) {
            char character = string.charAt(index);
            int charIndex = 0;
            for (int count = 0; count < VALID_CHARACTERS.length; ++count) {
                if (character != VALID_CHARACTERS[count]) continue;
                charIndex = count;
                break;
            }
            if (charIndex > 12) {
                charIndex += 195;
            }
            if (next == -1) {
                if (charIndex < 13) {
                    next = charIndex;
                    continue;
                }
                buffer.writeByte(charIndex);
                continue;
            }
            if (charIndex < 13) {
                buffer.writeByte((next << 4) + charIndex);
                next = -1;
                continue;
            }
            buffer.writeByte((next << 4) + (charIndex >> 4));
            next = charIndex & 0xF;
        }
        if (next != -1) {
            buffer.writeByte(next << 4);
        }
    }

    public static String processText(String string) {
        stream.resetPosition();
        ChatMessageCodec.encode(string, stream);
        int length = ChatMessageCodec.stream.pos;
        stream.resetPosition();
        return ChatMessageCodec.decode(length, stream);
    }
}

