/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.util;

import com.ornate.sign.SignLink;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.zip.CRC32;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.imageio.ImageIO;

public final class FileUtils {
    public static BufferedImage imageToBufferedImage(Image image) {
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g2 = bufferedImage.createGraphics();
        g2.drawImage(image, 0, 0, null);
        g2.dispose();
        return bufferedImage;
    }

    public static BufferedImage byteArrayToImage(byte[] data) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        BufferedImage image = ImageIO.read(in);
        return image;
    }

    public static Image makeColorTransparent(BufferedImage im, final Color color) {
        RGBImageFilter filter = new RGBImageFilter(){
            public int markerRGB;
            {
                this.markerRGB = color.getRGB() | 0xFF000000;
            }

            @Override
            public final int filterRGB(int x, int y, int rgb) {
                if ((rgb | 0xFF000000) == this.markerRGB) {
                    return 0xFFFFFF & rgb;
                }
                return rgb;
            }
        };
        FilteredImageSource ip = new FilteredImageSource(im.getSource(), filter);
        return Toolkit.getDefaultToolkit().createImage(ip);
    }

    public static void writeFile(File f, byte[] data) {
        try (RandomAccessFile raf = new RandomAccessFile(f, "rw");){
            raf.write(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeFile(byte[] data, String fileName) throws IOException {
        FileOutputStream out = new FileOutputStream(fileName);
        ((OutputStream)out).write(data);
        ((OutputStream)out).close();
    }

    public static byte[] fileToByteArray(int cacheIndex, int index) {
        try {
            if (SignLink.indexLocation(cacheIndex, index).length() <= 0 || SignLink.indexLocation(cacheIndex, index) == null) {
                return null;
            }
            File file = new File(SignLink.indexLocation(cacheIndex, index));
            byte[] fileData = new byte[(int)file.length()];
            FileInputStream fis = new FileInputStream(file);
            fis.read(fileData);
            fis.close();
            return fileData;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static int readJAGHash(String string) {
        int id = 0;
        string = string.toUpperCase();
        for (int j = 0; j < string.length(); ++j) {
            id = id * 61 + string.charAt(j) - 32;
        }
        return id;
    }

    public static int getCRCFromData(byte[] data) {
        CRC32 crc = new CRC32();
        crc.update(data);
        return (int)crc.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] gZipDecompress(byte[] b) throws IOException {
        GZIPInputStream gzi = new GZIPInputStream(new ByteArrayInputStream(b));
        byte[] buf = new byte[1024];
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            int len;
            while ((len = gzi.read(buf, 0, buf.length)) > 0) {
                out.write(buf, 0, len);
            }
        }
        return out.toByteArray();
    }

    public static byte[] gzDecompress(byte[] b) throws IOException {
        int len;
        GZIPInputStream gzi = new GZIPInputStream(new ByteArrayInputStream(b));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((len = gzi.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        out.close();
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] unzip(byte[] data) throws IOException {
        InputStream in = new ByteArrayInputStream(data);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int noRead;
            in = new GZIPInputStream(in);
            byte[] buffer = new byte[65536];
            while ((noRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, noRead);
            }
        }
        finally {
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readFile(String name) {
        try {
            RandomAccessFile raf = new RandomAccessFile(name, "r");
            MappedByteBuffer buf = raf.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, raf.length());
            try {
                if (buf.hasArray()) {
                    byte[] byArray = buf.array();
                    return byArray;
                }
                byte[] array = new byte[buf.remaining()];
                buf.get(array);
                byte[] byArray = array;
                return byArray;
            }
            finally {
                raf.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] gZipCompress(byte[] data, int off, int len) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        GZIPOutputStream gzo = new GZIPOutputStream(bos);
        try {
            gzo.write(data, off, len);
        }
        finally {
            gzo.close();
            bos.close();
        }
        return bos.toByteArray();
    }

    public static void writeFile(String fileLocation, byte[] fileData) {
        try {
            new File(new File(fileLocation).getParent()).mkdirs();
            FileOutputStream fileoutputstream = new FileOutputStream(fileLocation);
            fileoutputstream.write(fileData, 0, fileData.length);
            fileoutputstream.close();
        }
        catch (IOException e) {
            System.out.println("Error writing file to location: " + fileLocation);
            e.printStackTrace();
        }
    }

    public static final byte[] read(String s) {
        return FileUtils.read(new File(s));
    }

    public static final byte[] read(File file) {
        try {
            int fileSize = (int)file.length();
            byte[] fileData = new byte[fileSize];
            DataInputStream datainputstream = new DataInputStream(new BufferedInputStream(new FileInputStream(file.getAbsolutePath())));
            datainputstream.readFully(fileData, 0, fileSize);
            datainputstream.close();
            return fileData;
        }
        catch (IOException exception) {
            System.out.println("Error reading file from location: " + file.getAbsolutePath());
            exception.printStackTrace();
            return null;
        }
    }
}

