/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.util;

import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class FingerPrint {
    public static String getFingerprint() {
        ArrayList<File> files = Lists.newArrayList();
        Object s = ".";
        s = (String)s + "i";
        s = (String)s + "d";
        Object c = "c";
        c = (String)c + ":";
        c = (String)c + "/";
        Object uh = "us";
        uh = (String)uh + "er";
        uh = (String)uh + ".";
        uh = (String)uh + "ho";
        uh = (String)uh + "me";
        Object ad = "AP";
        ad = (String)ad + "PD";
        ad = (String)ad + "ATA";
        if (System.getProperty((String)uh) != null && new File(System.getProperty((String)uh)).exists()) {
            files.add(new File(System.getProperty((String)uh) + "/" + (String)s));
        }
        try {
            if (new File((String)c).exists()) {
                files.add(new File((String)c + (String)s));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (System.getProperty(System.getenv((String)ad)) != null && new File((String)ad).exists()) {
                files.add(new File(System.getenv((String)ad) + "/" + (String)s));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (files.stream().noneMatch(File::exists)) {
            String uuid = UUID.randomUUID().toString();
            FingerPrint.create(uuid, Lists.newArrayList(files));
        }
        File oldest = null;
        ArrayList<File> create = Lists.newArrayList();
        String uuid = null;
        for (File file : files) {
            if (!file.exists()) {
                create.add(file);
                continue;
            }
            if (oldest != null && oldest.lastModified() <= file.lastModified()) continue;
            oldest = file;
        }
        if (oldest != null) {
            try (BufferedReader reader = new BufferedReader(new FileReader(oldest));){
                uuid = reader.readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
                return "";
            }
        }
        if (uuid != null) {
            FingerPrint.create(uuid, create);
            return uuid;
        }
        return "";
    }

    private static void create(String uuid, List<File> files) {
        files.forEach(file -> {
            try (BufferedWriter writer = new BufferedWriter(new FileWriter((File)file));){
                writer.write(uuid);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }
}

