/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class Unzip {
    public static void unZipIt(String zipFile, String outputFolder, boolean deleteAfter) {
        byte[] buffer = new byte[1024];
        try {
            File folder = new File(outputFolder);
            if (!folder.exists()) {
                folder.mkdir();
            }
            ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                String fileName = ze.getName();
                File newFile = new File(outputFolder + File.separator + fileName);
                System.out.println("file unzip : " + String.valueOf(newFile.getAbsoluteFile()));
                new File(newFile.getParent()).mkdirs();
                if (!ze.isDirectory()) {
                    int len;
                    FileOutputStream fos = new FileOutputStream(newFile);
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                    fos.close();
                }
                ze = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
            if (deleteAfter) {
                new File(zipFile).delete();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

