/*
 * Decompiled with CFR 0.152.
 */
package com.ornate.util;

import java.lang.reflect.Method;

public final class Utils {
    private static final char[] validChars = new char[]{'_', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    public static final char[] INVALID_TITLE_CHARACTERS = new char[]{'_', '!', '@', '$', '%', '^', '&', '*', '(', ')', '-', '+', '=', ':', ';', '.', '>', '<', ',', '\"', '[', ']', '|', '?', '/', '`'};

    public static String ignoreColorTags(String text) {
        if (text.contains("<img=")) {
            int prefix = text.indexOf("<img=");
            int suffix = text.indexOf(">");
            long occurrences = text.chars().filter(ch -> ch == 62).count();
            if (suffix < prefix) {
                int i = 0;
                while ((long)i < occurrences && (suffix = Utils.nthOccurrence(text, ">", i)) <= prefix) {
                    ++i;
                }
            }
            text = text.replaceAll(text.substring(prefix + 5, suffix), "");
            text = text.replaceAll("</img>", "");
            text = text.replaceAll("<img=>", "");
        }
        return text;
    }

    public static String replaceIcons(String text) {
        if (text.contains("<img=")) {
            int prefix = text.indexOf("<img=");
            int suffix = text.indexOf(">");
            long occurrences = text.chars().filter(ch -> ch == 62).count();
            if (suffix < prefix) {
                int i = 0;
                while ((long)i < occurrences && (suffix = Utils.nthOccurrence(text, ">", i)) <= prefix) {
                    ++i;
                }
            }
            text = text.replaceAll(text.substring(prefix + 5, suffix), "");
            text = text.replaceAll("</img>", "");
            text = text.replaceAll("<img=>", "");
        } else if (text.contains("<ico=")) {
            int prefix = text.indexOf("<ico=");
            int suffix = text.indexOf(">");
            long occurrences = text.chars().filter(ch -> ch == 62).count();
            if (suffix < prefix) {
                int i = 0;
                while ((long)i < occurrences && (suffix = Utils.nthOccurrence(text, ">", i)) <= prefix) {
                    ++i;
                }
            }
            text = text.replaceAll(text.substring(prefix + 5, suffix), "");
            text = text.replaceAll("</ico>", "");
            text = text.replaceAll("<ico=>", "");
        }
        return text;
    }

    public static int ensureRange(int value, int min, int max) {
        return Math.min(Math.max(value, min), max);
    }

    public static int random(int min, int max) {
        return min + (int)(Math.random() * (double)(max - min + 1));
    }

    public static int random(int range) {
        return (int)(Math.random() * (double)(range + 1));
    }

    public static int nthOccurrence(String str1, String str2, int n) {
        String tempStr = str1;
        int tempIndex = -1;
        int finalIndex = 0;
        for (int occurrence = 0; occurrence < n; ++occurrence) {
            tempIndex = tempStr.indexOf(str2);
            if (tempIndex == -1) {
                finalIndex = 0;
                break;
            }
            tempStr = tempStr.substring(++tempIndex);
            finalIndex += tempIndex;
        }
        return --finalIndex;
    }

    public static int[] d2Tod1(int[][] array) {
        int[] newArray = new int[array.length * array[0].length];
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[i].length; ++j) {
                newArray[i * array[0].length + j] = array[i][j];
            }
        }
        return newArray;
    }

    public static int[][] d1Tod2(int[] array, int width) {
        int[][] newArray = new int[array.length / width][width];
        for (int i = 0; i < array.length; ++i) {
            newArray[i / width][i % width] = array[i];
        }
        return newArray;
    }

    public static void launchURL(String url) {
        String osName = System.getProperty("os.name");
        try {
            if (osName.startsWith("Mac OS")) {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, url);
            } else if (osName.startsWith("Windows")) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
            } else {
                String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape", "safari"};
                String browser = null;
                for (int count = 0; count < browsers.length && browser == null; ++count) {
                    if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() != 0) continue;
                    browser = browsers[count];
                }
                if (browser == null) {
                    throw new Exception("Could not find web browser");
                }
                Runtime.getRuntime().exec(new String[]{browser, url});
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static boolean hasInvalidChars(String title) {
        for (char c : INVALID_TITLE_CHARACTERS) {
            if (title.indexOf(c) == -1) continue;
            return true;
        }
        return false;
    }

    public static long longForName(String s) {
        long l = 0L;
        for (int i = 0; i < s.length() && i < 12; ++i) {
            char c = s.charAt(i);
            l *= 37L;
            if (c >= 'A' && c <= 'Z') {
                l += (long)('\u0001' + c - 65);
                continue;
            }
            if (c >= 'a' && c <= 'z') {
                l += (long)('\u0001' + c - 97);
                continue;
            }
            if (c < '0' || c > '9') continue;
            l += (long)(27 + c - 48);
        }
        while (l % 37L == 0L && l != 0L) {
            l /= 37L;
        }
        return l;
    }

    public static String nameForLong(long l) {
        try {
            if (l <= 0L || l >= 6582952005840035281L) {
                return "invalid_name";
            }
            if (l % 37L == 0L) {
                return "invalid_name";
            }
            int i = 0;
            char[] ac = new char[12];
            while (l != 0L) {
                long l1 = l;
                ac[11 - i++] = validChars[(int)(l1 - (l /= 37L) * 37L)];
            }
            return new String(ac, 12 - i, i);
        }
        catch (RuntimeException runtimeexception) {
            System.err.println("81570, " + l + ", -99, " + runtimeexception.toString());
            throw new RuntimeException();
        }
    }

    public static String fixName(String s) {
        if (s.length() > 0) {
            char[] ac = s.toCharArray();
            for (int j = 0; j < ac.length; ++j) {
                if (ac[j] != '_') continue;
                ac[j] = 32;
                if (j + 1 >= ac.length || ac[j + 1] < 'a' || ac[j + 1] > 'z') continue;
                ac[j + 1] = (char)(ac[j + 1] + 65 - 97);
            }
            if (ac[0] >= 'a' && ac[0] <= 'z') {
                ac[0] = (char)(ac[0] + 65 - 97);
            }
            return new String(ac);
        }
        return s;
    }
}

